<!DOCTYPE html>
<html lang="ru">
<head>
	{headers}
	<meta name="HandheldFriendly" content="true">
	<meta name="format-detection" content="telephone=no">
	<meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, width=device-width">
	<meta name="mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="default">

	<link rel="icon" type="image/png" href="/favicon-96x96.png" sizes="96x96" />
<link rel="icon" type="image/svg+xml" href="/favicon.svg" />
<link rel="shortcut icon" href="/favicon.ico" />
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png" />
<meta name="apple-mobile-web-app-title" content="Raketa" />
<link rel="manifest" href="/site.webmanifest" />
	<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Onest:wght@100..900&display=swap" rel="stylesheet">

    {include file="{THEME}/css/bootstrap.css"}
	{include file="{THEME}/css/style.css"}
</head>
<body>

    <!-- Preloader -->
    <div class="preloader">
        <div class="loader">
            <span></span>
        </div>
    </div>

    <!-- cursor effect-->
    <div class="cursor"></div>
    <!-- Header area  -->

    <!-- header-section start -->
    <header class="header-section w-100">
        <div class="py-sm-6 py-3 mx-xxl-20 mx-md-15 mx-3">
            <div class="d-flex align-items-center justify-content-between gap-xxl-10 gap-lg-8 w-100">
                <nav class="navbar-custom d-flex gap-lg-6 align-items-center flex-lg-row justify-content-start justify-content-lg-between w-100">
                    <div class="top-bar w-100 d-flex align-items-center gap-lg-0 gap-6">
                        <button class="navbar-toggle-btn d-block d-lg-none" type="button">
                            <span></span>
                            <span></span>
                            <span></span>
                            <span></span>
                        </button>
                        <a class="navbar-brand d-flex align-items-center gap-4" href="/">
                            <img class="w-100 logo2" src="{THEME}/images/logo.png" alt="logo">
                        </a>
                    </div>
                    <div class="navbar-toggle-item w-100 position-lg-relative">
                        <ul class="custom-nav gap-lg-7 gap-3 cursor-scale growDown2 ms-xxl-10" data-lenis-prevent="">
                         
                             <li class="menu-link">
                                <a href="/">Главная</a>
                            </li>
							<li class="menu-link">
                                <a href="https://t.me/r_tmSupport">Правила</a>
                            </li>
                           <li class="menu-link">
                                <a href="#">Города</a>
                            </li>
                              <li class="menu-link">
                                <a href="https://t.me/r_tmSupport">Отзывы</a>
                            </li>
							  <li class="menu-link">
                                <a href="https://t.me/r_tmSupport">Контакты</a>
                            </li>
                        </ul>
                    </div>
               <div class="header-btn-area d-flex align-items-center gap-sm-6 gap-3 w-100">
                    <a href="https://t.me/r_tmSupport" class="btn-rounded-cus wallet-btn border-0 d-flex align-items-center gap-3 p-2 rounded-5 position-relative">
                        <span class="btn-circle fs-2xl">
                         <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 511.999 511.999" style="enable-background:new 0 0 511.999 511.999;" xml:space="preserve"><g><g><path d="M501.974,41.949c-8.237-7.547-19.944-10.062-30.555-6.565L21.231,183.785c-12.269,4.044-20.589,14.996-21.196,27.899 c-0.606,12.904,6.649,24.589,18.483,29.768l90.405,39.554l266.17-147.723c6.501-3.608,14.66-1.922,19.2,3.961 c4.541,5.885,4.1,14.204-1.037,19.576L227.319,330.325L193.287,453.28l81.681-61.162l96.589,79.039 c5.626,4.606,12.502,7.008,19.513,7.008c3.338-0.001,6.708-0.545,9.986-1.657c10.166-3.447,17.702-11.744,20.159-22.193 l89.965-382.503C513.737,60.939,510.211,49.496,501.974,41.949z"/></g></g><g><g><path d="M132.476,302.325l31.261,144.992l35.612-128.661c0.662-2.394,1.907-4.587,3.623-6.381l100.029-104.59L132.476,302.325z"/></g></g></svg>
                        </span>
                        <span class="text-nowrap d-xl-block">Поддержка 24/7</span>
                    </a>
                    
                </div>
				</nav>
                
            </div>
        </div>
    </header>
    <!-- header-section end -->

   

    <!-- Hero Section start  -->
    <section class="hero-section pt-20 pb-120 position-relative w-100">
        <div class="gradient-bg"></div>
        <div class="gradient-bg2"></div>
        <div class="star-area">
            <div class="big-star">
                <img class="w-100" src="{THEME}/images/big-star.png" alt="star">
            </div>
            <div class="small-star">
                <img class="w-100" src="{THEME}/images/small-star.png" alt="star">
            </div>
        </div>
      
        <div class="container pt-120 pb-15">
            <div class="row g-6 justify-content-between">
                <div class="col-lg-7 col-md-12 col-sm-12">
                    <div class="hero-content">
                        <ul class="d-flex gap-3 fs-2xl fw-semibold heading-font mb-5 list-icon title-anim">
                            <li>Круглосуточно</li>
                            <li>Лучшее качество</li>
                            <li>Безопасность</li>
                        </ul>
                       [available=main]<h1 class="hero-title display-one tcn-1 cursor-scale growUp mb-5">
                            МАГАЗИН
                            <span class="d-block tcp-1">КАЙФА</span>
                          </h1>[/available]
                       
                        [available=cat] <h1 class="hero-title display-four tcn-1 cursor-scale growUp mb-5">
                            Купить Мефедрон, Гашиш и  Шишки
                            <span class="d-block tcp-1"> {category-title}</span>
                          </h1> [/available]
						<p class="card-text tcs-6 mb-10 fs-2xl">Лучший магазин для вашего удовольствия приветствует вас</p>
                       
                        [category=9-19] <a href="https://t.me/r1_tmbot" class="btn-half-border position-relative d-inline-block py-4 px-8 bgp-1 rounded-pill popupvideo mfp-iframe fw-semibold">Бот автопродаж</a>
                       [/category]
[category=20-26]<a href="https://t.me/r2_tmbot" class="btn-half-border position-relative d-inline-block py-4 px-8 bgp-1 rounded-pill popupvideo mfp-iframe fw-semibold">Бот автопродаж</a>
                        [/category]
               [not-category=9-26]<a href="https://t.me/r_tmSupport" class="btn-half-border position-relative d-inline-block py-4 px-8 bgp-1 rounded-pill popupvideo mfp-iframe fw-semibold">Бот автопродаж</a>[/not-category]         
                        
                    </div>
                </div>
                <div class="col-xl-3 col-md-2 col-4 order-lg-1 absolutehead">
                    <div class="hero-banner-area">
                        <div class="hero-banner-bg">
                            <img class="w-100" src="{THEME}/images/bg-1.png" alt="banner">
                        </div>
                        <div class="hero-banner-img">
                            <img class="w-100 hero" src="{THEME}/images/hero.png" alt="banner">
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5 col-md-12 order-md-1 order-lg-last">
                    <div class="hero-content">
                        <div class="card-area py-lg-8 py-6 px-lg-6 px-3 rounded-5 tilt mb-10" data-tilt="">
                            <h3 class="tcn-1 cursor-scale growDown mb-6 title-anim">
                               Преимущества
                            </h3>
                            <div class="hr-line mb-6"></div>
                            <div class="card-items d-grid gap-5">
                                <div class="card-item d-flex align-items-center gap-4">
                                    
                                    <div class="card-info">
                                        <h4 class="card-title fw-semibold tcn-1 mb-1 cursor-scale growDown2 dot-icon">
                                            Круглосуточные продажи
                                        </h4>
                                      
                                    </div>
                                </div>
                                <div class="hr-line"></div>
                                <div class="card-item d-flex align-items-center gap-4">
                                  
                                    <div class="card-info">
                                        <h4 class="card-title fw-semibold tcn-1 mb-1 cursor-scale growDown2 dot-icon">
                                            Всегда свежие и актуальные адреса
                                        </h4>
                                     
                                    </div>
                                </div>
                                <div class="hr-line"></div>
                                <div class="card-item d-flex align-items-center gap-4">
                                  
                                    <div class="card-info">
                                        <h4 class="card-title fw-semibold tcn-1 mb-1 cursor-scale growDown2 dot-icon">
                                           Лучшее качество на рынке
                                        </h4>
                                       
                                    </div>
                                </div>
								  <div class="hr-line"></div>
                                <div class="card-item d-flex align-items-center gap-4">
                                  
                                    <div class="card-info">
                                        <h4 class="card-title fw-semibold tcn-1 mb-1 cursor-scale growDown2 dot-icon">
                                          Безопасность - наш приоритет
                                        </h4>
                                       
                                    </div>
                                </div>
								 
								
								
								
                            </div>
                        </div>
                      
                    </div>
                </div>
            </div>
        </div>
        <div class="grid-lines overflow-hidden">
            <div class="lines">
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
                <div class="line"></div>
            </div>
            <div class="lines">
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
                <div class="line-vertical"></div>
            </div>
        </div>
    </section>
    <!-- Hero Section end  -->

   
  
    <!-- tournament section start -->
    <section class="tournament-section pb-30" id="tournament-hero">
     
        <div class="game-console-area">
            <img class="w-100" src="{THEME}/images/game-console2.png" alt="game-console">
        </div>
        <div class="red-ball top-50"></div>
        <div class="tournament-wrapper">
            <div class="tournament-wrapper-border">
                <div class="container pb-120">
                   
                    <div class="row justify-content-between align-items-center g-6">
                        {info}{content}
                        
 </div>
                </div>
            </div>
        </div>
    </section>
   
{include file="1gorod.tpl"}
{include file="2prem.tpl"}  
{include file="3seo.tpl"}

    
    <div class="call-to-action pt-120 pb-120 bgn-4 overflow-x-hidden" id="cta">
        <div class="container">
            <div class="row justify-content-between align-items-center g-6">
                <div class="col-lg-6">
                    <span class="display-three tcn-1 cursor-scale growUp mb-8 d-block title-anim">Закажите удовольствие прямо сейчас!</span>
                   
                </div>
                <div class="col-xl-5 col-lg-6">
                     <span class="fs-lg tcn-6">
                     Сделать заказ стало намного проще, для этого свяжитесь с менеджером в телеграм, либо используйте бота автопродаж
                    </span>
					 <div class="d-flex align-items-center gap-sm-6 gap-3 w-100 mt-5">
                    
                         
                         
                         [category=9-19]
                            <a href="https://t.me/r1_tmbot" class="btn-rounded-cus wallet-btn border-0 d-flex align-items-center gap-3 p-2 rounded-5 position-relative">
                        <span class="btn-circle fs-2xl">
                         <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 511.999 511.999" style="enable-background:new 0 0 511.999 511.999;" xml:space="preserve"><g><g><path d="M501.974,41.949c-8.237-7.547-19.944-10.062-30.555-6.565L21.231,183.785c-12.269,4.044-20.589,14.996-21.196,27.899 c-0.606,12.904,6.649,24.589,18.483,29.768l90.405,39.554l266.17-147.723c6.501-3.608,14.66-1.922,19.2,3.961 c4.541,5.885,4.1,14.204-1.037,19.576L227.319,330.325L193.287,453.28l81.681-61.162l96.589,79.039 c5.626,4.606,12.502,7.008,19.513,7.008c3.338-0.001,6.708-0.545,9.986-1.657c10.166-3.447,17.702-11.744,20.159-22.193 l89.965-382.503C513.737,60.939,510.211,49.496,501.974,41.949z"/></g></g><g><g><path d="M132.476,302.325l31.261,144.992l35.612-128.661c0.662-2.394,1.907-4.587,3.623-6.381l100.029-104.59L132.476,302.325z"/></g></g></svg>
                        </span>
                        <span class="text-nowrap d-xl-block">Поддержка 24/7</span>
                    </a> [/category]
[category=20-26]   <a href="https://t.me/r2_tmbot" class="btn-rounded-cus wallet-btn border-0 d-flex align-items-center gap-3 p-2 rounded-5 position-relative">
                        <span class="btn-circle fs-2xl">
                         <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 511.999 511.999" style="enable-background:new 0 0 511.999 511.999;" xml:space="preserve"><g><g><path d="M501.974,41.949c-8.237-7.547-19.944-10.062-30.555-6.565L21.231,183.785c-12.269,4.044-20.589,14.996-21.196,27.899 c-0.606,12.904,6.649,24.589,18.483,29.768l90.405,39.554l266.17-147.723c6.501-3.608,14.66-1.922,19.2,3.961 c4.541,5.885,4.1,14.204-1.037,19.576L227.319,330.325L193.287,453.28l81.681-61.162l96.589,79.039 c5.626,4.606,12.502,7.008,19.513,7.008c3.338-0.001,6.708-0.545,9.986-1.657c10.166-3.447,17.702-11.744,20.159-22.193 l89.965-382.503C513.737,60.939,510.211,49.496,501.974,41.949z"/></g></g><g><g><path d="M132.476,302.325l31.261,144.992l35.612-128.661c0.662-2.394,1.907-4.587,3.623-6.381l100.029-104.59L132.476,302.325z"/></g></g></svg>
                        </span>
                        <span class="text-nowrap d-xl-block">Поддержка 24/7</span>
                    </a>[/category]
               [not-category=9-26]
                           <a href="https://t.me/r_tmSupport" class="btn-rounded-cus wallet-btn border-0 d-flex align-items-center gap-3 p-2 rounded-5 position-relative">
                        <span class="btn-circle fs-2xl">
                         <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 511.999 511.999" style="enable-background:new 0 0 511.999 511.999;" xml:space="preserve"><g><g><path d="M501.974,41.949c-8.237-7.547-19.944-10.062-30.555-6.565L21.231,183.785c-12.269,4.044-20.589,14.996-21.196,27.899 c-0.606,12.904,6.649,24.589,18.483,29.768l90.405,39.554l266.17-147.723c6.501-3.608,14.66-1.922,19.2,3.961 c4.541,5.885,4.1,14.204-1.037,19.576L227.319,330.325L193.287,453.28l81.681-61.162l96.589,79.039 c5.626,4.606,12.502,7.008,19.513,7.008c3.338-0.001,6.708-0.545,9.986-1.657c10.166-3.447,17.702-11.744,20.159-22.193 l89.965-382.503C513.737,60.939,510.211,49.496,501.974,41.949z"/></g></g><g><g><path d="M132.476,302.325l31.261,144.992l35.612-128.661c0.662-2.394,1.907-4.587,3.623-6.381l100.029-104.59L132.476,302.325z"/></g></g></svg>
                        </span>
                        <span class="text-nowrap d-xl-block">Поддержка 24/7</span>
                    </a>
                         [/not-category]         
                        
                      
                    
                </div>
                </div>
            </div>
        </div>
    </div>
   {include file="4footer.tpl"}
    <!-- gsap  -->
    <script src="{THEME}/js/gsap.min.js"></script>
    <!-- gsap scroll trigger -->
    <script src="{THEME}/js/ScrollTrigger.min.js"></script>
    <!-- lenis  -->
    <script src="{THEME}/js/lenis.min.js"></script>
    <!-- gsap split text -->
    <script src="{THEME}/js/SplitText.min.js"></script>
    <!-- tilt js -->
    <script src="{THEME}/js/vanilla-tilt.js"></script>
    <!-- scroll magic -->
    <script src="{THEME}/js/ScrollMagic.min.js"></script>
    <!-- animation.gsap -->
    <script src="{THEME}/js/animation.gsap.min.js"></script>
    <!-- gsap customization  -->
    <script src="{THEME}/js/gsap-customization.js"></script>
    <!-- apex chart  -->
    <script src="{THEME}/js/apexcharts.js"></script>
    <!-- swiper js -->
    <script src="{THEME}/js/swiper-bundle.min.js"></script>
     <!-- bootstrap js -->
    <script src="{THEME}/js/bootstrap.bundle.min.js"></script>
    <!-- main js  -->
    <script src="{THEME}/js/main.js"></script>


</body>
</html>